﻿var capiModuleSyncHistory = {
    context: $(".v-capiModuleSyncHistory"),
    datatable: null,
    projectId: null,
    moduleId: null,
    initializeDataTable: function () {
        this.datatable = $(".h-capiSyncHistory-table", this.context).a4datatable({
            advancedFilter: false,
            displaySearchBox: false,
            ajaxAction: a4.getProjectAction("GetModuleCAPISyncHistories", "Diagnostics"),
            ajaxParams: { "projectId": capiModuleSyncHistory.projectId, "ModuleId": capiModuleSyncHistory.moduleId },
            columns: [
                { "Title": resources.StartDate, "Data": "StartDate", "Type": "date" },
                { "Title": resources.ProjectName, "Data": "ProjectName" },
                { "Title": resources.Interviewer, "Data": "Interviewer" },
                { "Title": resources.Workstation, "Data": "Workstation" },
                { "Title": resources.CaseID, "Data": "CaseID" },
                { "Title": resources.CaseResult, "Data": "CaseResult" },
                { "Title": resources.Completed, "Data": "Completed", "Type": "boolean", "ShowIcon": true },
                { "Title": resources.Status, "Data": "Status" },
                { "Title": resources.Comments, "Data": "Comments" },
                { "Title": resources.Action, "Data": "Action" }
            ],
            stateKey: "CAPIModuleSyncHistory",
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            },
            toolBar:{
                DisplayMode: dataTables.filterDisplayMode.dropdown,
                Items: [
                    { "Action": "clear", "Label": resources.Clear, "DisplayMode": dataTables.itemDisplayMode.always },
                    { "Action": "export", "Label": resources.Export, "DisplayMode": dataTables.itemDisplayMode.always }
                ]
            },
            toolBarParams: {
                align: "right"
            },
            toolBarClick: function (event, data) {
                var action = data.action;

                switch (action) {
                    case "clear":
                        capiModuleSyncHistory.clearTable();
                        break;
                    case "export":
                        capiModuleSyncHistory.exportExcel();
                        break;
                };

            }
        });
    },
    exportExcel: function () {
        a4.showBusyBox();
        a4.callServerMethod(a4.getProjectAction("ExportSynchHistories", "Diagnostics"), { projectId: capiModuleSyncHistory.projectId },
        function (result) {
            a4.hideBusyBox();
            window.location = a4.getProjectAction("GetSynchHistoriesFile", "Diagnostics", { fileName: result });
        },
        function (error) {
            a4.onAjaxPageMethodError(error);
        });
    },
    clearTable: function () {
        modalDialog.showConfirmDialog(confirmDeleteSynchHistoryResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteCAPISyncHistories", "Diagnostics"), { projectId: capiModuleSyncHistory.projectId },
                function () {
                    a4.showSuccessMessage(resources.ClearHistoryCompleted);
                    capiModuleSyncHistory.refreshContent();
                },
                function (error) {
                    a4.onAjaxPageMethodError(error);
                }
            );
        }, 250, 500);
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (capiModuleSyncHistory.context.length > 0) {
        capiModuleSyncHistory.projectId = $("#ProjectId", this.context).val();
        capiModuleSyncHistory.moduleId = $("#ModuleId", this.context).val();
        capiModuleSyncHistory.initializeDataTable();
    }
});